<?php

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;
use yii\helpers\Url;
use yii\widgets\MaskedInput; ?>
<div class="reg">
    <div class="col-lg-5">
        <div class="zagolovok">
            <h2>Регистрация</h2>
        </div>
        <?php
        $form = ActiveForm::begin([
            'id' => 'login-form',
            'options' => ['class' => 'form-horizontal'],
        ]) ?>
        <?= $form->field($model, 'surname')->textInput() ?>
        <?= $form->field($model, 'name')->textInput() ?>
        <?= $form->field($model, 'patronymic')->textInput() ?>
        <?= $form->field($model, 'phone')->widget(MaskedInput::class, [
            'mask' => '+7(999)-999-99-99',
        ]) ?>
        <?= $form->field($model, 'email')->textInput() ?>
        <?= $form->field($model, 'passport')->widget(MaskedInput::class, [
            'mask' => '9999 999999',
        ]) ?>
        <?= $form->field($model, 'adres')->textInput() ?>
        <?= $form->field($model, 'password')->passwordInput() ?>
        <?= $form->field($model, 'password_repeat')->passwordInput() ?>
        <div class="form-check mb-4">
            <input class="form-check-input" type="checkbox" id="customCheck1" required>
            <label class="form-check-label" for="customCheck1">
                Я согласен(на) с правилами регистрации
            </label>
        </div>
        <div class="form-group">
            <div class="d-flex justify-content-center align-items-center">
                <?= Html::submitButton('Зарегистрироваться', ['class' => 'btn btn-primary']) ?>
                <a href="<?= Url::toRoute(['site/login']); ?>">Есть аккаунт? Авторизация</a>
            </div>
        </div>
        <?php ActiveForm::end() ?>
    </div>
</div>




