<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "tours".
 *
 * @property int $id
 * @property string $name
 * @property string $img
 * @property string $description
 * @property string $date
 * @property int $price
 *
 * @property Application[] $applications
 */
class Tour extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'tours';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'img', 'description', 'price'], 'required'],
            [['description'], 'string'],
            [['date'], 'safe'],
            [['price'], 'integer'],
            [['name', 'img'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Название тура',
            'img' => 'Img',
            'description' => 'Описание тура',
            'date' => 'Дата',
            'price' => 'Цена',
        ];
    }

    /**
     * Gets query for [[Application]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getApplications()
    {
        return $this->hasMany(Application::class, ['tours_id' => 'id']);
    }

}
