<?php

namespace app\models;

use yii\base\Model;

class SignupForm extends Model
{
    public $surname;
    public $name;
    public $patronymic;
    public $phone;
    public $email;
    public $passport;
    public $adres;
    public $password;
    public $password_repeat;

    public function rules()
    {
        return [
            [['surname', 'name', 'email', 'phone', 'adres', 'password', 'password_repeat'], 'required'],
            [['name', 'surname', 'patronymic'], 'match', 'pattern' => '/^[а-яё\s\-]+$/iu', 'message' => 'Разрешены только кириллические символы, пробелы'],
            ['password', 'string', 'min' => 7],
            ['password_repeat', 'compare', 'compareAttribute' => 'password', 'message' => 'Пароли не совпадают'],
            ['email', 'email'],
            ['phone', 'match', 'pattern' => '/^\+7\(\d{3}\)-\d{3}-\d{2}-\d{2}$/', 'message' => 'Неверный формат номера телефона'],
            ['passport', 'string', 'max' => 11],
            ['passport',  'match',
                'pattern' => '/^\d{4} \d{6}$/',
                'message' => 'Введите паспорт в формате: 1234 567890'
            ],
        ];
    }

    public function signup()
    {
        if (!$this->validate()) {
            return null;
        }

        $user = new User();
        $user->surname = $this->surname;
        $user->name = $this->name;
        $user->patronymic = $this->patronymic;
        $user->phone = $this->phone;
        $user->email = $this->email;
        $user->passport = $this->passport;
        $user->adres = $this->adres;
        $user->setPassword($this->password);

        return $user->save() ? $user : null;
    }

    public function attributeLabels()
    {
        return [
            'surname' => 'Фамилия',
            'name' => 'Имя',
            'patronymic' => 'Отчество',
            'phone' => 'Номер телефона',
            'passport' => 'Серия и номер паспорта',
            'email' => 'Email',
            'adres' => 'Адрес проживания',
            'password' => 'Пароль',
        ];
    }
}