<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "applications".
 *
 * @property int $id
 * @property string $date_tour
 * @property int $count_people
 * @property int $payment_method
 * @property string|null $dop
 * @property string|null $comment
 * @property string $status
 * @property int $user_id
 * @property int $tours_id
 *
 * @property Tour $tours
 * @property User $user
 */
class Application extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'applications';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['dop', 'comment'], 'default', 'value' => null],
            [['status'], 'default', 'value' => 'Новая'],
            [['date_tour'], 'safe'],
            [['count_people', 'payment_method', 'user_id', 'tours_id'], 'required'],
            [['count_people', 'payment_method', 'user_id', 'tours_id'], 'integer'],
            [['dop', 'comment'], 'string'],
            [['status'], 'string', 'max' => 255],
            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['user_id' => 'id']],
            [['tours_id'], 'exist', 'skipOnError' => true, 'targetClass' => Tour::class, 'targetAttribute' => ['tours_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'date_tour' => 'Дата тура',
            'count_people' => 'Кол-во участников',
            'payment_method' => 'Способ оплаты',
            'dop' => 'Доп. информация',
            'comment' => 'Комментарий',
            'status' => 'Статус',
            'user_id' => 'Пользователь',
            'tours_id' => 'Тур',
        ];
    }

    /**
     * Gets query for [[Tours]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getTours()
    {
        return $this->hasOne(Tour::class, ['id' => 'tours_id']);
    }

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }

}
