<?php

namespace app\controllers;

use app\models\Application;
use app\models\SignupForm;
use app\models\Tour;
use app\models\User;
use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use app\models\LoginForm;
use app\models\ContactForm;

class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex()
    {

        $ts = Tour::find()
            ->orderBy(['date' => SORT_DESC])
            ->all();

        return $this->render('index', [
            'ts' => $ts
        ]);
    }

    /**
     * Login action.
     *
     * @return Response|string
     */
    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->goBack();
        }

        $model->password = '';
        return $this->render('login', [
            'model' => $model,
        ]);
    }

    /**
     * Logout action.
     *
     * @return Response
     */
    public function actionLogout()
    {
        Yii::$app->user->logout();

        return $this->goHome();
    }

    /**
     * Displays contact page.
     *
     * @return Response|string
     */
    public function actionContact()
    {
        $model = new ContactForm();
        if ($model->load(Yii::$app->request->post()) && $model->contact(Yii::$app->params['adminEmail'])) {
            Yii::$app->session->setFlash('contactFormSubmitted');

            return $this->refresh();
        }
        return $this->render('contact', [
            'model' => $model,
        ]);
    }

    /**
     * Displays about page.
     *
     * @return string
     */
    public function actionAbout()
    {
        return $this->render('about');
    }

    public function actionSignup()
    {
        $model = new SignupForm();
        if ($model->load(Yii::$app->request->post()) && $model->signup()) {
            Yii::$app->session->setFlash('success', 'Спасибо за регистрацию!');
            return $this->goHome();
        }
        return $this->render('signup', [
            'model' => $model,
        ]);
    }

    public function actionApplication()
    {
        if (Yii::$app->user->isGuest) {
            Yii::$app->session->setFlash('error', 'Чтобы подать заявку, необходимо авторизоваться.');
            return $this->redirect(['site/login']);
        }

        $model = new Application();


        $tours = Tour::find()
            ->select(['name', 'id'])
            ->indexBy('id')
            ->column();

        if ($model->load(Yii::$app->request->post())) {
            $model->user_id = Yii::$app->user->id;

            if ($model->save()) {
                Yii::$app->session->setFlash('success', 'Ваша заявка успешно отправлена!');
                return $this->refresh();
            } else {
                Yii::error('Ошибки сохранения: ' . print_r($model->errors, true));
                Yii::$app->session->setFlash('error', 'Произошла ошибка при отправке заявки. Проверьте правильность заполнения полей.');
            }
        }

        return $this->render('application', [
            'model' => $model,
            'tours' => $tours, // Передаем список туров в представление
        ]);
    }

    public function actionApplications()
    {
        if (Yii::$app->user->isGuest) {
            Yii::$app->session->setFlash('error', 'Чтобы подать заявку, необходимо авторизоваться.');
            return $this->redirect(['site/login']);
        }

        $user = User::findOne(Yii::$app->user->id);
        $applications = $user->applications;

        return $this->render('applications', [
            'applications' => $applications
        ]);
    }

    public function actionCatalog()
    {

    }
}